/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.keyboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.JEMU;
import jemu.ui.KeyTranslator;
import jemu.ui.Switches;

public class VirtualKeyBoard
extends JPanel {
    static boolean DEBUG = false;
    int[] keyEvents = new int[]{27, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 45, 61, 127, 8, 118, 119, 120, 9, 81, 87, 69, 82, 84, 89, 85, 73, 79, 80, 91, 65406, 10, 20, 65, 83, 68, 70, 71, 72, 74, 75, 76, 59, 222, 93, 115, 116, 117, 112, 113, 114, 16, 90, 88, 67, 86, 66, 78, 77, 44, 46, 47, 92, 16, 123, 38, 110, 17, 12, 32, 35, 37, 40, 39};
    BufferedImage mouse;
    BufferedImage tapeSnippet;
    KeyTranslator translator;
    int xBeg = 54;
    int yBeg = 107;
    int xEn = 605;
    int yEn = 285;
    int kWidt = 35;
    int kHeigh = 35;
    BufferedImage icon;
    BufferedImage holder;
    boolean ctrl;
    boolean shift;
    boolean capslock;
    boolean capsKey;
    boolean shiftKey;
    boolean ctrlKey = false;
    int lastx;
    int lasty;
    int CPC464 = 0;
    int CPC664 = 1;
    int CPC6128 = 2;
    int CPCModel = 2;
    int lastCPC = -1;
    String[] model = new String[]{"464", "664", "6128"};
    int[] keysX6128 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 0, 1, 2, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0, 1, 2, 0, 1, 2, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 0, 1, 2, 0, 1, 2, 3, 0, 1, 2, 0};
    int[] keysY6128 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 0};
    boolean[] keysNum6128 = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true, true, true, false};
    int[] keysX = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 0, 1, 2, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 0, 1, 2, 0, 1, 2, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 0, 1, 1, 2, 1, 1, 2, 0, 1, 2, 2};
    int[] keysY = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 6, 0, 6, 4, 1, 4, 6, 1, 2, 1, 1};
    boolean[] keysNum = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, true, false, true, true, true, true, true};
    int[][] XCPCKeys = new int[5][];
    int[] X_Keys_464_0 = new int[]{54, 90, 124, 160, 196, 230, 266, 301, 338, 374, 408, 444, 480, 516, 550, 604};
    int[] X_Keys_464_1 = new int[]{54, 106, 142, 178, 214, 249, 284, 320, 355, 390, 426, 461, 496, 533, 604, -1};
    int[] X_Keys_464_2 = new int[]{54, 116, 151, 185, 222, 257, 294, 329, 364, 400, 435, 470, 506, 542, 604, -1};
    int[] X_Keys_464_3 = new int[]{54, 134, 168, 204, 238, 275, 309, 346, 380, 416, 451, 488, 523, 604, -1, -1};
    int[] X_Keys_464_4 = new int[]{999, 169, 489, 585, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    int[] Keys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    int[] X_Keys_664_0 = new int[]{52, 88, 125, 162, 198, 233, 270, 306, 343, 380, 416, 452, 488, 525, 562, 615};
    int[] X_Keys_664_1 = new int[]{52, 105, 141, 178, 215, 250, 286, 323, 360, 396, 433, 469, 505, 541, 615, -1};
    int[] X_Keys_664_2 = new int[]{52, 114, 150, 186, 222, 258, 295, 332, 369, 406, 441, 478, 514, 551, 615, -1};
    int[] X_Keys_664_3 = new int[]{52, 133, 167, 204, 240, 277, 312, 351, 386, 423, 459, 496, 532, 615, -1, -1};
    int[] X_Keys_664_4 = new int[]{999, 168, 496, 534, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    int[] X_Keys_6128_0 = new int[]{67, 105, 144, 183, 221, 260, 299, 338, 377, 417, 456, 494, 533, 572, 612, 650, 689, 728, 767};
    int[] X_Keys_6128_1 = new int[]{999, 67, 123, 161, 202, 239, 277, 317, 356, 395, 434, 474, 514, 552, 590, 650, 689, 728, 767};
    int[] X_Keys_6128_2 = new int[]{999, 67, 132, 170, 209, 248, 288, 327, 365, 404, 444, 482, 522, 560, 597, 650, 689, 728, 767};
    int[] X_Keys_6128_3 = new int[]{67, 152, 191, 230, 269, 308, 347, 386, 425, 464, 503, 542, 581, 650, 650, 650, 689, 728, 767};
    int[] X_Keys_6128_4 = new int[]{67, 153, 223, 535, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 689, 728, 767};
    boolean[] pressed = new boolean[this.keyEvents.length];
    int preSelectX = 10;
    int preSelectY = 284;
    boolean preSelect = false;
    public boolean allowSchneider;
    int FKeybX = 638;
    int FKeybY = 23;
    int FKeyeX = 740;
    int FKeyeY = 280;
    BufferedImage cursorImg = new BufferedImage(16, 16, 2);
    Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.cursorImg, new Point(0, 0), "blank cursor");
    int matrixX;
    int matrixY;
    int keyIndex = 0;
    boolean show = true;
    private JLabel jLabel1;

    public VirtualKeyBoard() {
        try {
            String Icon2 = "/jemu/core/device/keyboard/pointer.png";
            this.mouse = ImageIO.read(this.getClass().getResource(Icon2));
            Icon2 = "/jemu/core/device/keyboard/tapesnippet.png";
            this.tapeSnippet = ImageIO.read(this.getClass().getResource(Icon2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.translator = new KeyTranslator();
        this.initComponents();
        this.jLabel1.setFocusTraversalKeysEnabled(false);
        this.XCPCKeys[0] = this.X_Keys_464_0;
        this.XCPCKeys[1] = this.X_Keys_464_1;
        this.XCPCKeys[2] = this.X_Keys_464_2;
        this.XCPCKeys[3] = this.X_Keys_464_3;
        this.XCPCKeys[4] = this.X_Keys_464_4;
        this.reset();
        this.showKey();
    }

    public void handlePreselectedKeys() {
        Thread v = new Thread(){

            @Override
            public void run() {
                int i;
                for (i = 0; i < VirtualKeyBoard.this.keyEvents.length; ++i) {
                    if (!VirtualKeyBoard.this.pressed[i] || GateArray.cpc == null) continue;
                    GateArray.cpc.keyPressed(VirtualKeyBoard.this.keyEvents[i]);
                }
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (i = 0; i < VirtualKeyBoard.this.keyEvents.length; ++i) {
                    if (!VirtualKeyBoard.this.pressed[i] || GateArray.cpc == null) continue;
                    GateArray.cpc.keyReleased(VirtualKeyBoard.this.keyEvents[i]);
                }
            }
        };
        v.start();
    }

    public void pressKey(int key) {
        while (this.icon == null) {
            this.init();
        }
        if (this.holder == null) {
            this.holder = new BufferedImage(this.icon.getWidth(), this.icon.getHeight(), 1);
        }
        Graphics2D d = this.holder.createGraphics();
        this.drawPanel(d);
        d.setColor(Color.blue);
        for (int i = 0; i < this.keyEvents.length; ++i) {
            if (key == this.keyEvents[i]) {
                this.pressed[i] = true;
            }
            if (this.CPCModel == 2) {
                this.redraw6128(this.keysX6128[i], this.keysY6128[i], this.keysNum6128[i], d, i);
                continue;
            }
            this.redraw(this.keysX[i], this.keysY[i], this.keysNum[i], d, i);
        }
        this.jLabel1.setIcon(new ImageIcon(this.holder));
    }

    public void showKey() {
        while (this.icon == null) {
            this.init();
        }
        if (this.holder == null) {
            this.holder = new BufferedImage(this.icon.getWidth(), this.icon.getHeight(), 1);
        }
        Graphics2D d = this.holder.createGraphics();
        this.drawPanel(d);
        d.setColor(Color.white);
        for (int i = 0; i < this.keyEvents.length; ++i) {
            if (this.CPCModel == 2) {
                this.redraw6128(this.keysX6128[i], this.keysY6128[i], this.keysNum6128[i], d, i);
                continue;
            }
            this.redraw(this.keysX[i], this.keysY[i], this.keysNum[i], d, i);
        }
        this.jLabel1.setIcon(new ImageIcon(this.holder));
    }

    protected void drawPanel(Graphics d) {
        d.drawImage(this.icon, 0, 0, null);
        if (this.CPCModel == 0 && (CPC.tapesample != null || DEBUG)) {
            d.drawImage(this.tapeSnippet, 803, 69, null);
        }
        d.setColor(Color.LIGHT_GRAY);
        d.setFont(new Font("Tahoma", 1, 13));
        d.drawString("Pre-Select", 32, 296);
        d.drawRect(28, 284, 74, 14);
        d.drawRect(29, 284, 74, 14);
        d.drawRect(29, 285, 74, 14);
        d.drawRect(28, 285, 74, 14);
        d.drawRect(10, 284, 14, 14);
        d.drawRect(11, 284, 14, 14);
        d.drawRect(11, 285, 14, 14);
        d.drawRect(10, 285, 14, 14);
        if (this.preSelect) {
            d.drawLine(10, 284, 24, 298);
            d.drawLine(11, 284, 25, 298);
            d.drawLine(10, 285, 24, 299);
            d.drawLine(10, 298, 24, 284);
            d.drawLine(11, 299, 25, 284);
            d.drawLine(11, 298, 24, 285);
        }
    }

    public void releaseKey(int key) {
        Graphics2D d = this.holder.createGraphics();
        this.drawPanel(d);
        d.setColor(Color.white);
        for (int i = 0; i < this.keyEvents.length; ++i) {
            if (key == this.keyEvents[i]) {
                this.pressed[i] = false;
            }
            if (this.CPCModel == 2) {
                this.redraw6128(this.keysX6128[i], this.keysY6128[i], this.keysNum6128[i], d, i);
                continue;
            }
            this.redraw(this.keysX[i], this.keysY[i], this.keysNum[i], d, i);
        }
        this.jLabel1.setIcon(new ImageIcon(this.holder));
    }

    public void init() {
        switch (this.CPCModel) {
            case 0: {
                this.XCPCKeys[0] = this.X_Keys_464_0;
                this.XCPCKeys[1] = this.X_Keys_464_1;
                this.XCPCKeys[2] = this.X_Keys_464_2;
                this.XCPCKeys[3] = this.X_Keys_464_3;
                this.XCPCKeys[4] = this.X_Keys_464_4;
                break;
            }
            case 1: {
                this.XCPCKeys[0] = this.X_Keys_664_0;
                this.XCPCKeys[1] = this.X_Keys_664_1;
                this.XCPCKeys[2] = this.X_Keys_664_2;
                this.XCPCKeys[3] = this.X_Keys_664_3;
                this.XCPCKeys[4] = this.X_Keys_664_4;
                break;
            }
            case 2: {
                this.XCPCKeys[0] = this.X_Keys_6128_0;
                this.XCPCKeys[1] = this.X_Keys_6128_1;
                this.XCPCKeys[2] = this.X_Keys_6128_2;
                this.XCPCKeys[3] = this.X_Keys_6128_3;
                this.XCPCKeys[4] = this.X_Keys_6128_4;
            }
        }
        try {
            this.allowSchneider = Switches.computername == 5;
            String locale = "";
            if (CPC.language.equals("es") & (this.CPCModel == 0 || this.CPCModel == 2)) {
                locale = "_es";
            }
            if (CPC.language.equals("fr") & (this.CPCModel == 0 || this.CPCModel == 2)) {
                locale = "_fr";
            }
            if (CPC.language.equals("de") & this.allowSchneider) {
                locale = "_de";
            }
            String Icon2 = "/jemu/core/device/keyboard/" + this.model[this.CPCModel] + "_cut" + locale + ".png";
            this.icon = ImageIO.read(this.getClass().getResource(Icon2));
            this.showKey();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.preSelect = false;
        for (int i = 0; i < this.pressed.length; ++i) {
            this.pressed[i] = false;
        }
        this.capslock = false;
        this.ctrl = false;
        this.shift = false;
        if (!DEBUG) {
            switch (Switches.ROM) {
                case "CPC464": {
                    this.CPCModel = 0;
                    break;
                }
                case "CPC664": {
                    this.CPCModel = 1;
                    break;
                }
                case "CPC6128": {
                    this.CPCModel = 2;
                    break;
                }
                default: {
                    this.CPCModel = 0;
                }
            }
        }
        if (this.lastCPC != this.CPCModel) {
            this.lastCPC = this.CPCModel;
        }
        this.init();
    }

    void setKeyXYNum(int key, int x, int y, boolean num) {
        for (int i = 0; i < this.keyEvents.length; ++i) {
            if (i != key) continue;
            this.keysX6128[i] = x;
            this.keysY6128[i] = y;
            this.keysNum6128[i] = num;
            break;
        }
    }

    void redraw(int x, int y, boolean num, Graphics d, int key) {
        int width;
        int posY;
        int posX;
        int addbegin;
        int addwidth;
        int ybegin;
        if (!DEBUG) {
            switch (Switches.ROM) {
                case "CPC464": {
                    this.CPCModel = 0;
                    break;
                }
                case "CPC664": {
                    this.CPCModel = 1;
                    break;
                }
                case "CPC6128": {
                    this.CPCModel = 2;
                    break;
                }
                default: {
                    this.CPCModel = 0;
                }
            }
        }
        if (this.lastCPC != this.CPCModel) {
            this.lastCPC = this.CPCModel;
            this.init();
            this.redraw(x, y, num, d, key);
        }
        int xBegF = 638;
        int yBegF = 23;
        int xEndF = 740;
        int yEndF = 280;
        int xBegin = 54;
        int yBegin = 107;
        int xEnd = 605;
        int yEnd = 285;
        int kWidth = 35;
        int kHeight = 35;
        this.lastx = x;
        this.lasty = y;
        if (this.CPCModel == 1) {
            xBegin -= 2;
            yBegF += 28;
            xBegF += 14;
            yEndF += 20;
            xEndF += 28;
            yBegin += 17;
            ++kWidth;
            ++kHeight;
            yEnd += 20;
        }
        d.setColor(Color.green);
        if ((this.CPCModel == 0 || this.CPCModel == 1) && num) {
            ybegin = 0;
            if (y > 2) {
                ybegin = this.CPCModel == 0 ? (ybegin += 15) : (ybegin += 2);
            }
            addwidth = 0;
            addbegin = 0;
            posX = addbegin + xBegF + x * kWidth;
            posY = ybegin + yBegF + y * kHeight;
            width = addwidth + kWidth;
            boolean skip = false;
            if (!(y != 0 && y != 2 || x != 0 && x != 2)) {
                skip = true;
            }
            if (!skip && this.pressed[key]) {
                if (y < 3 && this.CPCModel == 1) {
                    Polygon polygon = new Polygon();
                    switch (y) {
                        case 0: {
                            if (x != 1) break;
                            polygon.addPoint(++posX - kWidth, posY);
                            polygon.addPoint(posX, posY + kHeight);
                            polygon.addPoint(posX + kWidth, posY + kHeight);
                            polygon.addPoint(posX + kWidth * 2, posY);
                            d.drawPolygon(polygon);
                            d.setColor(new Color(255, 255, 255, 128));
                            d.fillPolygon(polygon);
                            break;
                        }
                        case 1: {
                            ++posY;
                            if (x == 0) {
                                polygon.addPoint(posX, posY - kHeight);
                                polygon.addPoint(posX, posY + kHeight * 2);
                                polygon.addPoint(posX + kWidth, posY + kHeight);
                                polygon.addPoint(posX + kWidth, posY);
                                d.drawPolygon(polygon);
                                d.setColor(new Color(255, 255, 255, 128));
                                d.fillPolygon(polygon);
                            }
                            if (x == 1) {
                                d.drawRect(++posX, posY, width, kHeight);
                                d.setColor(new Color(255, 255, 255, 128));
                                d.fillRect(posX + 1, posY + 1, width - 2, kHeight - 2);
                            }
                            if (x != 2) break;
                            polygon.addPoint(posX += 2, posY);
                            polygon.addPoint(posX, posY + kHeight);
                            polygon.addPoint(posX + kWidth, posY + kHeight * 2);
                            polygon.addPoint(posX + kWidth, posY - kHeight);
                            d.drawPolygon(polygon);
                            d.setColor(new Color(255, 255, 255, 128));
                            d.fillPolygon(polygon);
                            break;
                        }
                        case 2: {
                            if (x != 1) break;
                            polygon.addPoint(++posX, posY += 2);
                            polygon.addPoint(posX + kWidth, posY);
                            polygon.addPoint(posX + kWidth * 2, posY + kHeight);
                            polygon.addPoint(posX - kWidth, posY + kHeight);
                            d.drawPolygon(polygon);
                            d.setColor(new Color(255, 255, 255, 128));
                            d.fillPolygon(polygon);
                        }
                    }
                } else {
                    d.drawRect(posX, posY, width, kHeight);
                    d.setColor(new Color(255, 255, 255, 128));
                    d.fillRect(posX + 1, posY + 1, width - 2, kHeight - 2);
                }
            }
            int n = y * 3 + x;
        }
        if (!num) {
            ybegin = 0;
            addwidth = 0;
            addbegin = 0;
            if (this.pressed[key] && DEBUG) {
                System.out.println(key);
            }
            if (key == 31 && this.pressed[key]) {
                addbegin = 16 + (x - 1 >> 1);
                int dotX = addbegin + xBegin + x * kWidth;
                int dotY = ybegin + yBegin + y * kHeight;
                d.drawLine(dotX, dotY, dotX, 36 + dotY);
                d.drawLine(dotX, dotY, dotX + 72, dotY);
                d.drawLine(dotX + 73, dotY, dotX + 73, dotY + 70);
                d.drawLine(dotX + 73, dotY + 70, dotX + 10, dotY + 70);
                d.drawLine(dotX + 10, dotY + 70, dotX + 10, dotY + 36);
                d.drawLine(dotX + 10, dotY + 36, dotX, dotY + 36);
                d.setColor(new Color(255, 255, 255, 128));
                d.fillRect(dotX + 1, dotY + 1, 70, 35);
                d.fillRect(dotX + 11, dotY + 36, 60, 34);
            } else {
                if (this.pressed[key] && DEBUG) {
                    System.out.println(x + "," + y);
                }
                addbegin += x >> 1;
                if (x == 14 && y == 0) {
                    addwidth += 17;
                }
                if (y == 1) {
                    if (x < 1) {
                        addwidth = 17;
                    } else {
                        addbegin = 17 + (x - 1 >> 1);
                    }
                }
                if (y == 2) {
                    if (x < 1) {
                        addwidth = 26;
                    } else {
                        addbegin = 26 + (x - 1 >> 1);
                    }
                }
                if (y == 3) {
                    if (x < 1) {
                        addwidth = 44;
                    } else {
                        addbegin = 44 + (x - 1 >> 1);
                    }
                    if (x >= 12) {
                        addwidth += 46;
                        addbegin = 44 + (x - 1 >> 1);
                    }
                }
                if (y == 4) {
                    ybegin = 1;
                    int modelAdd = 0;
                    if (this.CPCModel == 1) {
                        modelAdd = 8;
                    }
                    if (x < 2) {
                        addbegin = 80 + (x - 1 >> 1);
                        addwidth += 285 + modelAdd;
                    } else {
                        addbegin = 365 + (x - 1 >> 1) + modelAdd;
                        addwidth = 0;
                    }
                }
                if (y > 4) {
                    return;
                }
                if (this.pressed[key]) {
                    posX = addbegin + xBegin + x * kWidth;
                    posY = ybegin + yBegin + y * kHeight;
                    width = addwidth + kWidth;
                    d.drawRect(posX, posY, width, kHeight);
                    d.setColor(new Color(255, 255, 255, 128));
                    d.fillRect(posX + 1, posY + 1, width - 2, kHeight - 2);
                }
            }
        }
    }

    void redraw6128(int x, int y, boolean num, Graphics d, int key) {
        int xBegin = 66;
        int yBegin = 82;
        int xEnd = 732;
        int yEnd = 275;
        int kWidth = 37;
        int kHeight = 37;
        d.setColor(Color.green);
        if (this.pressed[key]) {
            int addwidth = 0;
            int addbegin = 0;
            if (!num) {
                if ((y == 1 || y == 2) && x >= 14) {
                    x = 14;
                    y = 1;
                    addbegin = -20;
                    int i = (xBegin += x << 1) + addbegin + x * kWidth;
                    int j = (yBegin += y << 1) + y * kHeight;
                    d.drawLine(i, j, i + 57, j);
                    d.drawLine(i + 57, j, i + 57, j + 76);
                    d.drawLine(i + 57, j + 76, i + 7, j + 76);
                    d.drawLine(i + 7, j + 76, i + 7, j + 37);
                    d.drawLine(i + 7, j + 37, i, j + 37);
                    d.drawLine(i, j + 37, i, j);
                    d.setColor(new Color(255, 255, 255, 128));
                    d.fillRect(i, j, 57, 37);
                    d.fillRect(i + 8, j + 37, 50, 37);
                    this.jLabel1.setIcon(new ImageIcon(this.holder));
                    return;
                }
                if (y == 1) {
                    if (x < 2) {
                        addwidth = 19;
                        addbegin = -39;
                    } else {
                        addbegin = -20;
                    }
                }
                if (y == 2) {
                    if (x < 2) {
                        addwidth = 26;
                        addbegin = -39;
                    } else {
                        addbegin = -13;
                    }
                }
                if (y == 3) {
                    if (x < 1) {
                        addwidth = 47;
                    } else {
                        addbegin = 48;
                    }
                    if (x == 12) {
                        addwidth = 30;
                    }
                }
                if (y == 4) {
                    if (x < 1) {
                        addwidth = 47;
                    } else {
                        addbegin = 48;
                    }
                    if (x == 1 && y == 4) {
                        addwidth = 32;
                    }
                    if (x > 1 && x < 13) {
                        addbegin = 80;
                        if (x < 3) {
                            addwidth = 274;
                        } else {
                            addbegin += 274;
                            addwidth = 75;
                        }
                    }
                }
            } else {
                addbegin = 651 - xBegin;
            }
            int posX = (xBegin += x << 1) + addbegin + x * kWidth;
            int posY = (yBegin += y << 1) + y * kHeight;
            int width = addwidth + kWidth;
            if (DEBUG) {
                System.out.println(posX + "," + posY + "," + width + "," + kHeight);
            }
            d.drawRect(posX, posY, width, kHeight);
            d.setColor(new Color(255, 255, 255, 128));
            d.fillRect(posX + 1, posY + 1, width - 2, kHeight - 2);
        }
    }

    void redraw6128(int rx, int py) {
        if (this.preSelect && rx > 28 && rx < 102 && py > 284 && py < 298) {
            this.jLabel1.setCursor(new Cursor(12));
            this.showKey();
            return;
        }
        int mX = rx;
        int mY = py;
        int xBegin = 66;
        int yBegin = 82;
        int xEnd = 766;
        int yEnd = 275;
        int kWidth = 37;
        int kHeight = 37;
        this.lastx = rx;
        this.lasty = py;
        this.keyIndex = -1;
        Graphics2D d = this.holder.createGraphics();
        this.drawPanel(d);
        d.setColor(Color.blue);
        if (rx > xBegin && rx < xEnd && py > yBegin && py < yEnd) {
            this.jLabel1.setCursor(this.blankCursor);
            int y = py;
            y -= yBegin;
            int px = 0;
            if ((y /= kHeight) < 5) {
                for (int i = 0; i < this.XCPCKeys[y].length; ++i) {
                    if (rx < this.XCPCKeys[y][i] || rx > this.XCPCKeys[y][i + 1]) continue;
                    px = this.Keys[i];
                    break;
                }
            } else {
                px -= xBegin;
                px /= kWidth;
            }
            int x = px;
            int addwidth = 0;
            int addbegin = 0;
            boolean FKeys = true;
            if (x < 15) {
                FKeys = false;
                if ((y == 1 || y == 2) && x >= 14) {
                    x = 14;
                    y = 1;
                    addbegin = -20;
                    int i = (xBegin += x << 1) + addbegin + x * kWidth;
                    int j = (yBegin += y << 1) + y * kHeight;
                    if (this.preSelect && this.show) {
                        this.showKey();
                    }
                    d.drawLine(i, j, i + 57, j);
                    d.drawLine(i + 57, j, i + 57, j + 76);
                    d.drawLine(i + 57, j + 76, i + 7, j + 76);
                    d.drawLine(i + 7, j + 76, i + 7, j + 37);
                    d.drawLine(i + 7, j + 37, i, j + 37);
                    d.drawLine(i, j + 37, i, j);
                    d.setColor(new Color(255, 255, 255, 128));
                    d.fillRect(i, j, 57, 37);
                    d.fillRect(i + 8, j + 37, 50, 37);
                    d.drawImage((Image)this.mouse, mX, mY, null);
                    this.keyIndex = 31;
                    if (this.keyIndex >= 0 && DEBUG) {
                        this.setKeyXYNum(this.keyIndex, x, y, false);
                    }
                    this.jLabel1.setIcon(new ImageIcon(this.holder));
                    return;
                }
                if (y == 1) {
                    if (x < 2) {
                        addwidth = 19;
                        addbegin = -39;
                    } else {
                        addbegin = -20;
                    }
                }
                if (y == 2) {
                    if (x < 2) {
                        addwidth = 26;
                        addbegin = -39;
                    } else {
                        addbegin = -13;
                    }
                }
                if (y == 3) {
                    if (x < 1) {
                        addwidth = 47;
                    } else {
                        addbegin = 48;
                    }
                    if (x == 12) {
                        addwidth = 30;
                    }
                }
                if (y == 4) {
                    if (x < 1) {
                        addwidth = 47;
                    } else {
                        addbegin = 48;
                    }
                    if (x == 1 && y == 4) {
                        addwidth = 32;
                    }
                    if (x > 1 && x < 13) {
                        addbegin = 80;
                        if (x < 3) {
                            addwidth = 274;
                        } else {
                            addbegin += 274;
                            addwidth = 75;
                        }
                    }
                }
            } else {
                addwidth = 0;
                addbegin = 0;
            }
            if (y > 4) {
                this.jLabel1.setCursor(Cursor.getDefaultCursor());
                if (this.preSelect && this.show) {
                    this.showKey();
                }
                this.jLabel1.setIcon(new ImageIcon(this.holder));
                return;
            }
            if (!FKeys) {
                switch (y) {
                    case 0: {
                        this.keyIndex = x;
                        break;
                    }
                    case 1: {
                        this.keyIndex = 17 + x;
                        break;
                    }
                    case 2: {
                        this.keyIndex = 31 + x;
                        break;
                    }
                    case 3: {
                        this.keyIndex = 51 + x;
                        if (this.keyIndex != 49) break;
                        this.keyIndex = 63;
                        break;
                    }
                    case 4: {
                        this.keyIndex = 67 + x;
                    }
                }
                if (this.keyIndex >= 0 && DEBUG) {
                    this.setKeyXYNum(this.keyIndex, x, y, false);
                }
            }
            int posX = (xBegin += x << 1) + addbegin + x * kWidth;
            int posY = (yBegin += y << 1) + y * kHeight;
            int width = addwidth + kWidth;
            if (DEBUG) {
                System.out.println(posX + "," + posY + "," + width + "," + kHeight);
            }
            if (this.preSelect && this.show) {
                this.showKey();
            }
            d.drawRect(posX, posY, width, kHeight);
            d.setColor(new Color(255, 255, 255, 128));
            d.fillRect(posX + 1, posY + 1, width - 2, kHeight - 2);
            d.drawImage((Image)this.mouse, mX, mY, null);
            this.jLabel1.setIcon(new ImageIcon(this.holder));
            if (FKeys) {
                int pos = y * 3 + (x -= 15);
                this.keyIndex = -1;
                switch (pos) {
                    case 0: {
                        this.keyIndex = 15;
                        break;
                    }
                    case 1: {
                        this.keyIndex = 16;
                        break;
                    }
                    case 2: {
                        this.keyIndex = 17;
                        break;
                    }
                    case 3: {
                        this.keyIndex = 45;
                        break;
                    }
                    case 4: {
                        this.keyIndex = 46;
                        break;
                    }
                    case 5: {
                        this.keyIndex = 47;
                        break;
                    }
                    case 6: {
                        this.keyIndex = 48;
                        break;
                    }
                    case 7: {
                        this.keyIndex = 49;
                        break;
                    }
                    case 8: {
                        this.keyIndex = 50;
                        break;
                    }
                    case 9: {
                        this.keyIndex = 64;
                        break;
                    }
                    case 10: {
                        this.keyIndex = 65;
                        break;
                    }
                    case 11: {
                        this.keyIndex = 66;
                        break;
                    }
                    case 12: {
                        this.keyIndex = 71;
                        break;
                    }
                    case 13: {
                        this.keyIndex = 72;
                        break;
                    }
                    case 14: {
                        this.keyIndex = 73;
                    }
                }
                if (this.keyIndex >= 0 && DEBUG) {
                    this.setKeyXYNum(this.keyIndex, x, y, true);
                }
            }
            this.matrixX = x;
            this.matrixY = y;
        } else {
            if (this.show) {
                this.showKey();
            }
            this.jLabel1.setCursor(Cursor.getDefaultCursor());
        }
        d.setColor(new Color(0, 0, 0, 128));
        if (this.capslock) {
            d.fillRect(67, 160, 65, 37);
        }
        if (this.shift) {
            d.fillRect(582, 199, 68, 37);
            d.fillRect(66, 199, 85, 37);
        }
        if (this.ctrl) {
            d.fillRect(66, 238, 85, 37);
        }
    }

    void redraw(int rx, int y) {
        int width;
        int posY;
        int posX;
        int addbegin;
        int addwidth;
        int ybegin;
        int x;
        if (rx > 28 && rx < 102 && y > 284 && y < 298) {
            this.jLabel1.setCursor(new Cursor(12));
            this.showKey();
            return;
        }
        int mX = rx;
        int mY = y;
        if (!DEBUG) {
            switch (Switches.ROM) {
                case "CPC464": {
                    this.CPCModel = 0;
                    break;
                }
                case "CPC664": {
                    this.CPCModel = 1;
                    break;
                }
                case "CPC6128": {
                    this.CPCModel = 2;
                    break;
                }
                default: {
                    this.CPCModel = 0;
                }
            }
        }
        if (this.lastCPC != this.CPCModel) {
            this.lastCPC = this.CPCModel;
            this.init();
            this.redraw(this.lastx, this.lasty);
        }
        while (this.icon == null) {
            this.init();
        }
        if (this.holder == null) {
            this.holder = new BufferedImage(this.icon.getWidth(), this.icon.getHeight(), 1);
        }
        if (this.CPCModel == 2) {
            this.redraw6128(rx, y);
            return;
        }
        int xBegF = 638;
        int yBegF = 23;
        int xEndF = 740;
        int yEndF = 280;
        int xBegin = 54;
        int yBegin = 107;
        int xEnd = 605;
        int yEnd = 285;
        int kWidth = 35;
        int kHeight = 35;
        this.lastx = rx;
        this.lasty = y;
        this.keyIndex = -1;
        if (this.CPCModel == 1) {
            xBegin -= 2;
            yBegF += 28;
            xBegF += 14;
            yEndF += 20;
            xEndF += 20;
            yBegin += 17;
            ++kWidth;
            ++kHeight;
            yEnd += 20;
            xEnd += 10;
        }
        Graphics2D d = this.holder.createGraphics();
        this.drawPanel(d);
        d.setColor(Color.blue);
        boolean FKeys = false;
        if (this.CPCModel == 0 || this.CPCModel == 1) {
            if (rx > xBegF && rx < xEndF && y > yBegF && y < yEndF) {
                this.jLabel1.setCursor(this.blankCursor);
                FKeys = true;
                x = rx;
                x -= xBegF;
                y -= yBegF;
                x /= kWidth;
                ybegin = 0;
                if ((y /= kHeight) > 2) {
                    if (this.CPCModel == 0) {
                        ybegin += 15;
                        mY += 15;
                    } else {
                        ybegin += 2;
                        mY += 2;
                    }
                }
                addwidth = 0;
                addbegin = 0;
                posX = addbegin + xBegF + x * kWidth;
                posY = ybegin + yBegF + y * kHeight;
                width = addwidth + kWidth;
                boolean skip = false;
                if (!(y != 0 && y != 2 || x != 0 && x != 2)) {
                    skip = true;
                }
                if (this.preSelect && this.show) {
                    this.showKey();
                    d.drawImage((Image)this.mouse, mX, mY, null);
                }
                if (!skip) {
                    if (y < 3 && this.CPCModel == 1) {
                        Polygon polygon = new Polygon();
                        switch (y) {
                            case 0: {
                                if (x != 1) break;
                                polygon.addPoint(++posX - kWidth, posY);
                                polygon.addPoint(posX, posY + kHeight);
                                polygon.addPoint(posX + kWidth, posY + kHeight);
                                polygon.addPoint(posX + kWidth * 2, posY);
                                d.drawPolygon(polygon);
                                d.setColor(new Color(255, 255, 255, 128));
                                d.fillPolygon(polygon);
                                break;
                            }
                            case 1: {
                                ++posY;
                                if (x == 0) {
                                    polygon.addPoint(posX, posY - kHeight);
                                    polygon.addPoint(posX, posY + kHeight * 2);
                                    polygon.addPoint(posX + kWidth, posY + kHeight);
                                    polygon.addPoint(posX + kWidth, posY);
                                    d.drawPolygon(polygon);
                                    d.setColor(new Color(255, 255, 255, 128));
                                    d.fillPolygon(polygon);
                                }
                                if (x == 1) {
                                    d.drawRect(++posX, posY, width, kHeight);
                                    d.setColor(new Color(255, 255, 255, 128));
                                    d.fillRect(posX + 1, posY + 1, width - 2, kHeight - 2);
                                }
                                if (x != 2) break;
                                polygon.addPoint(posX += 2, posY);
                                polygon.addPoint(posX, posY + kHeight);
                                polygon.addPoint(posX + kWidth, posY + kHeight * 2);
                                polygon.addPoint(posX + kWidth, posY - kHeight);
                                d.drawPolygon(polygon);
                                d.setColor(new Color(255, 255, 255, 128));
                                d.fillPolygon(polygon);
                                break;
                            }
                            case 2: {
                                posY += 2;
                                if (x != 1) break;
                                polygon.addPoint(posX, posY);
                                polygon.addPoint(posX + kWidth, posY);
                                polygon.addPoint(posX + kWidth * 2, posY + kHeight);
                                polygon.addPoint(posX - kWidth, posY + kHeight);
                                d.drawPolygon(polygon);
                                d.setColor(new Color(255, 255, 255, 128));
                                d.fillPolygon(polygon);
                            }
                        }
                    } else {
                        d.drawRect(posX, posY, width, kHeight);
                        d.setColor(new Color(255, 255, 255, 128));
                        d.fillRect(posX + 1, posY + 1, width - 2, kHeight - 2);
                    }
                }
                d.drawImage((Image)this.mouse, mX, mY, null);
                int pos = y * 3 + x;
                this.keyIndex = -1;
                switch (pos) {
                    case 1: {
                        this.keyIndex = 65;
                        break;
                    }
                    case 3: {
                        this.keyIndex = 71;
                        break;
                    }
                    case 4: {
                        this.keyIndex = 68;
                        break;
                    }
                    case 5: {
                        this.keyIndex = 73;
                        break;
                    }
                    case 7: {
                        this.keyIndex = 72;
                        break;
                    }
                    case 9: {
                        this.keyIndex = 15;
                        break;
                    }
                    case 10: {
                        this.keyIndex = 16;
                        break;
                    }
                    case 11: {
                        this.keyIndex = 17;
                        break;
                    }
                    case 12: {
                        this.keyIndex = 45;
                        break;
                    }
                    case 13: {
                        this.keyIndex = 46;
                        break;
                    }
                    case 14: {
                        this.keyIndex = 47;
                        break;
                    }
                    case 15: {
                        this.keyIndex = 48;
                        break;
                    }
                    case 16: {
                        this.keyIndex = 49;
                        break;
                    }
                    case 17: {
                        this.keyIndex = 50;
                        break;
                    }
                    case 18: {
                        this.keyIndex = 64;
                        break;
                    }
                    case 19: {
                        this.keyIndex = 66;
                        break;
                    }
                    case 20: {
                        this.keyIndex = 70;
                    }
                }
                if (DEBUG) {
                    System.out.println(x + "," + y);
                }
                if (this.keyIndex >= 0 && DEBUG) {
                    this.setKeyXYNum(this.keyIndex, x, y, true);
                }
                if (this.preSelect) {
                    this.jLabel1.setIcon(new ImageIcon(this.holder));
                    return;
                }
            } else if (FKeys) {
                this.jLabel1.setCursor(Cursor.getDefaultCursor());
            }
        }
        if (rx >= xBegin && rx <= xEnd && y >= yBegin && y <= yEnd && !FKeys) {
            this.jLabel1.setCursor(this.blankCursor);
            this.keyIndex = -1;
            y -= yBegin;
            x = 0;
            if ((y /= kHeight) < 5) {
                for (int i = 0; i < this.XCPCKeys[y].length - 1; ++i) {
                    if (rx < this.XCPCKeys[y][i] || rx > this.XCPCKeys[y][i + 1]) continue;
                    x = this.Keys[i];
                    break;
                }
            } else {
                y = 4;
            }
            ybegin = 0;
            addwidth = 0;
            addbegin = 0;
            if ((y == 1 || y == 2) && x >= 13) {
                y = 1;
                x = 13;
                addbegin = 16 + (x - 1 >> 1);
                int dotX = addbegin + xBegin + x * kWidth;
                int dotY = ybegin + yBegin + y * kHeight;
                if (this.preSelect && this.show) {
                    this.showKey();
                    d.drawImage((Image)this.mouse, mX, mY, null);
                }
                d.drawLine(dotX, dotY, dotX, 36 + dotY);
                d.drawLine(dotX, dotY, dotX + 72, dotY);
                d.drawLine(dotX + 73, dotY, dotX + 73, dotY + 70);
                d.drawLine(dotX + 73, dotY + 70, dotX + 10, dotY + 70);
                d.drawLine(dotX + 10, dotY + 70, dotX + 10, dotY + 36);
                d.drawLine(dotX + 10, dotY + 36, dotX, dotY + 36);
                d.setColor(new Color(255, 255, 255, 128));
                d.fillRect(dotX + 1, dotY + 1, 70, 35);
                d.fillRect(dotX + 11, dotY + 36, 60, 34);
                d.drawImage((Image)this.mouse, mX, mY, null);
            } else {
                if (x >= 14 && y >= 0) {
                    x = 14;
                }
                mX -= (addbegin += x >> 1);
                if (x == 14 && y == 0) {
                    addwidth += 17;
                }
                if (y == 1) {
                    if (x < 1) {
                        addwidth = 17;
                    } else {
                        addbegin = 17 + (x - 1 >> 1);
                    }
                }
                if (y == 2) {
                    if (x < 1) {
                        addwidth = 26;
                    } else {
                        addbegin = 26 + (x - 1 >> 1);
                    }
                }
                if (y == 3) {
                    if (x < 1) {
                        addwidth = 44;
                    } else {
                        addbegin = 44 + (x - 1 >> 1);
                    }
                    if (x >= 12) {
                        x = 12;
                        addwidth += 46;
                        addbegin = 44 + (x - 1 >> 1);
                    }
                }
                if (y == 4) {
                    ybegin = 1;
                    int modelAdd = 0;
                    if (this.CPCModel == 1) {
                        modelAdd = 8;
                    }
                    if (x <= 0) {
                        this.showKey();
                        d.drawImage((Image)this.mouse, mX, mY, null);
                        return;
                    }
                    if (x < 2) {
                        System.out.println("Space");
                        addbegin = 80 + (x - 1 >> 1);
                        addwidth += 285 + modelAdd;
                        this.keyIndex = 69;
                    } else {
                        System.out.println("CTRL");
                        addbegin = 365 + (x - 1 >> 1) + modelAdd;
                        addwidth = 0;
                        this.keyIndex = 67;
                    }
                }
                if (y > 4) {
                    if (this.preSelect && this.show) {
                        this.showKey();
                        d.drawImage((Image)this.mouse, mX, mY, null);
                    }
                    return;
                }
                if (this.preSelect && this.show) {
                    this.showKey();
                    d.drawImage((Image)this.mouse, mX, mY, null);
                }
                posX = addbegin + xBegin + x * kWidth;
                posY = ybegin + yBegin + y * kHeight;
                width = addwidth + kWidth;
                d.drawRect(posX, posY, width, kHeight);
                d.setColor(new Color(255, 255, 255, 128));
                d.fillRect(posX + 1, posY + 1, width - 2, kHeight - 2);
                d.drawImage((Image)this.mouse, mX, mY, null);
                if (DEBUG) {
                    System.out.println(posX + "," + posY + "," + width + "," + kHeight);
                }
            }
            switch (y) {
                case 0: {
                    this.keyIndex = x;
                    break;
                }
                case 1: {
                    this.keyIndex = 18 + x;
                    break;
                }
                case 2: {
                    this.keyIndex = 32 + x;
                    break;
                }
                case 3: {
                    this.keyIndex = 51 + x;
                }
            }
            if (this.keyIndex >= 0 && DEBUG) {
                this.setKeyXYNum(this.keyIndex, x, y, false);
            }
            if (DEBUG) {
                System.out.println(x + "," + y + ", Index = " + this.keyIndex);
            }
        } else {
            if (this.preSelect && this.show) {
                this.showKey();
            }
            if (!FKeys) {
                this.jLabel1.setCursor(Cursor.getDefaultCursor());
            }
        }
        d.setColor(new Color(0, 0, 0, 128));
        if (this.capslock) {
            if (this.CPCModel == 1) {
                d.fillRect(51, 195, 64, 37);
            } else {
                d.fillRect(52, 178, 64, 35);
            }
        }
        if (this.shift) {
            if (this.CPCModel == 1) {
                d.fillRect(51, 231, 82, 37);
                d.fillRect(532, 231, 86, 37);
            } else {
                d.fillRect(523, 213, 81, 35);
                d.fillRect(53, 213, 79, 35);
            }
        }
        if (this.ctrl) {
            if (this.CPCModel == 1) {
                d.fillRect(496, 268, 37, 37);
            } else {
                d.fillRect(489, 248, 35, 36);
            }
        }
        this.jLabel1.setIcon(new ImageIcon(this.holder));
    }

    public static void main(String[] args) {
        final JFrame fram = new JFrame("Virtual Keyboard");
        fram.setLayout(new BorderLayout());
        DEBUG = true;
        VirtualKeyBoard key = new VirtualKeyBoard();
        fram.add((Component)key, "Center");
        fram.pack();
        fram.setResizable(false);
        fram.setDefaultCloseOperation(3);
        Thread v = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fram.pack();
                fram.setVisible(true);
                fram.setAlwaysOnTop(true);
            }
        };
        v.start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/jemu/core/device/keyboard/464_cut.png")));
        this.jLabel1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                VirtualKeyBoard.this.jLabel1MouseMoved(evt);
            }
        });
        this.jLabel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VirtualKeyBoard.this.jLabel1MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                VirtualKeyBoard.this.jLabel1MouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                VirtualKeyBoard.this.jLabel1MousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                VirtualKeyBoard.this.jLabel1MouseReleased(evt);
            }
        });
        this.jLabel1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                VirtualKeyBoard.this.jLabel1KeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                VirtualKeyBoard.this.jLabel1KeyReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1));
    }

    private void jLabel1MouseMoved(MouseEvent evt) {
        this.redraw(evt.getX(), evt.getY());
    }

    private void jLabel1MouseReleased(MouseEvent evt) {
        if (this.preSelect) {
            if (this.keyIndex >= 0) {
                this.pressed[this.keyIndex] = !this.pressed[this.keyIndex];
            }
            this.show = true;
            this.showKey();
            return;
        }
        if (this.keyIndex >= 0 && GateArray.cpc != null) {
            if (DEBUG) {
                System.out.println("Releasing key " + this.keyIndex);
            }
            if (this.capslock || this.shift) {
                GateArray.cpc.keyReleased(16);
            }
            if (this.ctrl) {
                GateArray.cpc.keyReleased(17);
            }
            GateArray.cpc.keyReleased(this.keyEvents[this.keyIndex]);
            if (Switches.KeyboardSound) {
                GateArray.cpc.keySample(this.keyEvents[this.keyIndex], true);
            }
        }
    }

    private void jLabel1MousePressed(MouseEvent evt) {
        if (DEBUG) {
            System.out.println(this.matrixX + "," + this.matrixY);
        }
        if (this.preSelect) {
            this.show = false;
            return;
        }
        if (this.keyIndex == 32) {
            if (this.capsKey) {
                this.capslock = false;
                this.capsKey = false;
            } else {
                this.capslock = true;
                this.capsKey = true;
            }
            return;
        }
        if (this.keyIndex == 67) {
            if (this.ctrlKey) {
                this.ctrl = false;
                this.ctrlKey = false;
            } else {
                this.ctrl = true;
                this.ctrlKey = true;
            }
            return;
        }
        if (this.keyIndex == 51 || this.keyIndex == 63) {
            if (this.shiftKey) {
                this.shiftKey = false;
                this.shift = false;
            } else {
                this.shiftKey = true;
                this.shift = true;
            }
            return;
        }
        if (this.keyIndex >= 0) {
            if (this.capslock || this.shift) {
                if (!this.shift && this.capslock && (this.keyIndex > 18 && this.keyIndex < 29 || this.keyIndex > 32 && this.keyIndex < 42 || this.keyIndex > 51 && this.keyIndex < 59)) {
                    if (DEBUG) {
                        System.out.println("pressing shift");
                    }
                    if (GateArray.cpc != null) {
                        GateArray.cpc.keyPressed(16);
                    }
                } else if (this.shift && GateArray.cpc != null) {
                    GateArray.cpc.keyPressed(16);
                }
            }
            if (this.ctrl && GateArray.cpc != null) {
                GateArray.cpc.keyPressed(17);
            }
            if (DEBUG) {
                System.out.println("pressing key " + this.keyIndex + "," + this.keyEvents[this.keyIndex]);
            }
            if (GateArray.cpc != null) {
                GateArray.cpc.keyPressed(this.keyEvents[this.keyIndex]);
                if (Switches.KeyboardSound) {
                    GateArray.cpc.keySample(this.keyEvents[this.keyIndex], false);
                }
            }
        }
    }

    protected void printKeys() {
        if (DEBUG) {
            int i;
            int pos = 0;
            System.out.println("int[] keysX6128 = {");
            for (i = 0; i < this.keysX6128.length; ++i) {
                System.out.print(this.keysX6128[i] + ",");
                if (++pos != 10) continue;
                System.out.println();
                pos = 0;
            }
            System.out.println("};");
            pos = 0;
            System.out.println("int[] keysY6128 = {");
            for (i = 0; i < this.keysY6128.length; ++i) {
                System.out.print(this.keysY6128[i] + ",");
                if (++pos != 10) continue;
                System.out.println();
                pos = 0;
            }
            System.out.println("};");
            pos = 0;
            System.out.println("boolean[] keysNum6128 = {");
            for (i = 0; i < this.keysNum6128.length; ++i) {
                System.out.print(this.keysNum6128[i] + ",");
                if (++pos != 10) continue;
                System.out.println();
                pos = 0;
            }
            System.out.println("};");
            System.exit(0);
        }
    }

    private void jLabel1KeyPressed(KeyEvent evt) {
        if (DEBUG) {
            System.out.println(evt.getKeyCode());
        }
        if (GateArray.cpc != null) {
            evt = this.translator.translate(evt, JEMU.localkeys);
            GateArray.cpc.keyPressed(evt);
            evt.consume();
        }
    }

    private void jLabel1MouseEntered(MouseEvent evt) {
        this.jLabel1.requestFocus();
    }

    private void jLabel1KeyReleased(KeyEvent evt) {
        if (DEBUG && evt.getKeyCode() == 10) {
            this.printKeys();
        }
        if (GateArray.cpc != null) {
            evt = this.translator.translate(evt, JEMU.localkeys);
            GateArray.cpc.keyReleased(evt);
            evt.consume();
        }
    }

    private void jLabel1MouseClicked(MouseEvent evt) {
        int i;
        int x = evt.getX();
        int y = evt.getY();
        if (x > 10 && x < 24 && y > 284 && y < 298) {
            boolean bl = this.preSelect = !this.preSelect;
            if (!this.preSelect) {
                for (i = 0; i < this.pressed.length; ++i) {
                    this.pressed[i] = false;
                }
            }
            this.showKey();
            this.init();
        }
        if (this.preSelect && x > 28 && x < 102 && y > 284 && y < 298) {
            this.handlePreselectedKeys();
        }
        if (evt.getClickCount() > 1 && DEBUG) {
            ++this.CPCModel;
            if (this.CPCModel > 2) {
                this.CPCModel = 0;
            }
            for (i = 0; i < this.pressed.length; ++i) {
                this.pressed[i] = false;
            }
            this.reset();
        }
    }
}

